<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");

session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 

?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Questions</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Questions</li>
        </ol>




        <div class="row my-4">
            <div class="col-12 add-category-box mb-3">
                <h1 class="category-heading questions-heading">Add Questions</h1>
                <div class="categort-add-container questions-add-container mb-3">
                    <div class="mb-3 add-question-btn-container d-flex justify-content-between align-items-center flex-wrap">
                        <div class="import-question-container">
                        <form action="export.php" class="d-flex align-items-center flex-wrap" enctype="multipart/form-data" method="post">
                            <div class="mb-3">
                                <label for="impFile" class="form-label">Import CSV, Xlsx</label>
                                <input required class="form-control" type="file" name="impFile" id="impFile">
                            </div>
                            <div class="mb-3 mx-2">
                                <label for="quiz_id" class="form-label">Select Quiz</label>
                                <select name="quiz_id" class="form-select" required>
                                    <option value="">Select Quiz</option>
                                    <?php
                            
                            $sql = "SELECT * FROM `quizzes`";

                            $query_run = mysqli_query($conn, $sql);

                            if ($query_run):

                                if (mysqli_num_rows($query_run)):
                                    foreach ($query_run as $row):
?>


                                    <option value="<?= $row['id']; ?>">
                                        <?= $row['name']; ?>
                                    </option>

                                    <?php
                endforeach;
                            else:
?>
                                    <option value="no">No Quiz Available</option>


                                    <?php

                            endif;

                            else:
                                echo "Some Error Occured";

                            endif;
                            
                            ?>
                                </select>

                            </div>
                        <div class="pt-3">
                        <button  class="simple-btn add-questions-btn" name="import_questions_btn" type="submit">Import Questions</button>
                        </div>
                        </form>
                        </div>
                        <div class="import-question-container">
                        <a  class="simple-btn add-question-btn" data-bs-toggle="modal" data-bs-target="#addindQuestion" href="#">Add Individual Question</a>
                        </div>

                    </div>

                    <div class="instructions">
                            <h1>How to add questions ?</h1>
                            <p>1. To import bulk questions.</p>
                            <p> 2. You have to create a .CSV or .XLSX file according to you format given you can download it.</p>
                            <p>  3. After creatng questions file you have to upload it on the admin panel.</p>
                            <p>  4. After uploading on the admin panel you have to select the quiz then click on import.</p>
                            <p>    5. That's it all questions were uploaded.</p>
                            <p>  6. To add questions individually.</p>
                            <p>   7. You have click on add individual question button.</p>
                            <p>   8. Fill the required fields and thcn click on add button. </p>
                        </div>                    
            </div>
        </div>
    </div>
    <div class="row mb-4">

        <div class="user-table">

            <div class="useractioncontainer d-flex align-items-center justify-content-between">
                <a herf="javascript:void(0)" onclick="delete_all()" class="delete-user-btn">Delete Selected
                    Questions</a>

                <div class="dropdown">
                    <a class="download-data-btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                        aria-expanded="false">
                        Download
                    </a>

                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="export.php?export_questions_csv=true">CSV</a></li>
                        <li><a class="dropdown-item" href="export.php?export_questions_excel=true">Excel</a>
                        </li>
                    </ul>
                </div>
            </div>
            <form method="post" id="frm">
                <table id="example" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="hide-sort"><input type="checkbox" onclick="select_all()" id="delete"></th>
                            <th class=" d-none">
                                <?= $row['id']; ?>
                                </td>
                            <th>SR No.</th>
                            <th>Question</th>
                            <th>Image</th>
                            <th>Option A</th>
                            <th>Option B</th>
                            <th>Option C</th>
                            <th>Option D</th>
                            <th>Answer</th>
                            <th>Quiz</th>
                            <th>Diffuculty</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
            
            $sql = "SELECT * FROM `questions`";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):
                       
                        ?>



                        <tr id="box<?= $row['id']; ?>">
                            <td><input type="checkbox" name="checkbox3[]" class='input' value="<?= $row['id']; ?>"
                                    id="<?= $row['id']; ?>"></td>
                            <td class="ques_id d-none"><?= $row['id']; ?></td>
                            <td>
                                <?= $i; ?>
                            </td>
                            <td>
                                <?= $row['question']; ?>
                            </td>

                            <td>
                                
                                <?php
                                
                                    if ($row['image'] == ''):
?>
                                        
<?php
                                    else:

?>
                                    <img style="width: 50px; height: 50px;" src="<?= $row['image']; ?>" alt="Image">
<?php
                                    endif;
                                
                                ?>
                            
                           
                            </td>

                            <td>
                            <?= $row['optionA']; ?>
                            </td>
                            <td>
                                <?= $row['optionB']; ?>
                            </td>
                            <td>
                                <?= $row['optionC']; ?>
                            </td>
                            <td>
                                <?= $row['optionD']; ?>
                            </td>
                            <td>
                                <?= $row['answer']; ?>
                            </td>
                            <td>
                                <?php
                                    $quiz_id = $row['quizId'];
                                    $quiz_sql = "SELECT * FROM `quizzes` WHERE `id`='$quiz_id'";

                                    $query_run_quiz = mysqli_query($conn, $quiz_sql);

                                    if ($query_run_quiz):
                                    if (mysqli_num_rows($query_run_quiz) > 0):
                                        foreach ($query_run_quiz as $key):
?>

                                            <?= $key['name']; ?>
<?php
                                        endforeach;
                                        else:
                                            echo "No Quiz";
                                        endif;
                                    else:
                                        echo "Error Occured";
                                    endif;


                                    
                                    
                                    ?>
                            </td>
                            <td>
                                <?= $row['difficulty']; ?>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <a class="edit-user edit-btn" href=""><i class="fa-solid fa-pen-to-square"></i></a>
                                    <button class="delete-user delete-question" name="deletquestion"
                                        value="<?= $row['id']; ?>"><i class="fa-solid fa-trash"></i></button>
                                </div>
                            </td>
                        </tr>


                        <?php

                        $i++;
                    endforeach;








                else:
                    echo "No Category Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                    </tbody>
                </table>
            </form>


        </div>
    </div>




    <!-- Modal -->
    <div class="modal fade" id="editQuestion" tabindex="-1" aria-labelledby="editQuestionLabel" aria-hidden="true">
        <div class="modal-dialog  modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="editQuestionLabel">Edit Category</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                <form action="code.php" method="post" enctype="multipart/form-data">
                <div class="mb-3">
                                <label for="catLabel" class="form-label">Image</label>
                                <div class="img-container d-flex justify-content-center align-items-center mb-4">
                                    <img alt="image" id="image" style="width: 100px; height: 100px;">
                                </div>
                                <input type="file" class="form-control" id="image" class="image"
                                    name="image">
                                <input type="hidden" class="oldImage" name="oldImage">
                                <input type="hidden" class="id" name="id">
                            </div>
                            <div class="mb-3">
                                <label for="question" class="form-label">Question</label>
                                <input type="text" class="form-control" id="question" name="question" required>
                                <input type="hidden" class="form-control" id="id" name="id">
                            </div>
                            <div class="mb-3">
                                <label for="optionA" class="form-label">Option A</label>
                                <input type="text" class="form-control" id="optionA" name="optionA">
                            </div>
                            <div class="mb-3">
                                <label for="optionB" class="form-label">Option B</label>
                                <input type="text" class="form-control" id="optionB" name="optionB">
                            </div>
                            <div class="mb-3">
                                <label for="optionC" class="form-label">Option C</label>
                                <input type="text" class="form-control" id="optionC" name="optionC">
                            </div>
                            <div class="mb-3">
                                <label for="optionD" class="form-label">Option D</label>
                                <input type="text" class="form-control" id="optionD" name="optionD">
                            </div>
                            <div class="mb-3">
                            <label for="answer" class="form-label">Select Answer</label>
                                <select class="form-select" name="answer" required>
                                    <option value="" id="ans">Select Answer</option>
                                    <option id="sel-optionA"  value="" id="ansA">Option A</option>
                                    <option  id="sel-optionB" value="" id="ansB">Option B</option>
                                    <option  id="sel-optionC" value="" id="ansC">Option C</option>
                                    <option  id="sel-optionD" value="" id="ansD">Option D</option>
                                </select>
                                </div>
                                <div class="mb-3">
                                <label for="quiz_id" class="form-label">Select Quiz</label>
                                <select name="quiz_id" class="form-select" required>
                                    <option id="ques_quiz" value="">Select Quiz</option>
                                    <?php
                            
                            $sql = "SELECT * FROM `quizzes`";

                            $query_run = mysqli_query($conn, $sql);

                            if ($query_run):

                                if (mysqli_num_rows($query_run)):
                                    foreach ($query_run as $row):
?>


                                    <option value="<?= $row['id']; ?>">
                                        <?= $row['name']; ?>
                                    </option>

                                    <?php
                endforeach;
                            else:
?>
                                    <option value="no">No Quiz Available</option>


                                    <?php

                            endif;

                            else:
                                echo "Some Error Occured";

                            endif;
                            
                            ?>
                                </select>

                            </div>
                            <div class="mb-3">
                            <label for="difficulty" class="form-label">Select Difficulty</label>
                                <select class="form-select" name="difficulty" required>
                                    <option id="diff" value="">Select Difficulty</option>
                                    <option id="easy" value="EASY">Easy</option>
                                    <option id="medium" value="MEDIUM">Medium</option>
                                    <option id="hard" value="HARD">Hard</option>
                                </select>
                                </div>
                            <button type="submit" name="edit_question" class="simple-btn btn btn-primary add-ind-question">Edit</button>
                        </form>
                </div>
            </div>
        </div>
    </div>



    </div>


    <!-- Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="deleteModalLabel">Delete Question</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="code.php" method="post">
                    <div class="modal-body">
                        <p>Are you sure to delete this Question ?</p>
                        <input type="hidden" name="del_id" class="delete-ques-id" id="del_id">
                    </div>
                    <div class="modal-footer d-flex justify-content-start">

                        <button type="submit" class="btn btn-primary delButton" name="delQuesBtn">Yes!
                            Delete</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addindQuestion" tabindex="-1" aria-labelledby="addindQuestionLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="addindQuestionLabel">Add Question</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                    <div class="modal-body">
                        <form action="code.php" method="post" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="image" class="form-label">Image</label>
                                <input type="file" class="form-control" id="image" name="image">
                            </div>
                            <div class="mb-3">
                                <label for="question" class="form-label">Question</label>
                                <input type="text" class="form-control" id="question" name="question" required>
                            </div>
                            <div class="mb-3">
                                <label for="optionA" class="form-label">Option A</label>
                                <input type="text" class="form-control" id="optionA" name="optionA">
                            </div>
                            <div class="mb-3">
                                <label for="optionB" class="form-label">Option B</label>
                                <input type="text" class="form-control" id="optionB" name="optionB">
                            </div>
                            <div class="mb-3">
                                <label for="optionC" class="form-label">Option C</label>
                                <input type="text" class="form-control" id="optionC" name="optionC">
                            </div>
                            <div class="mb-3">
                                <label for="optionD" class="form-label">Option D</label>
                                <input type="text" class="form-control" id="optionD" name="optionD">
                            </div>
                            <div class="mb-3">
                            <label for="answer" class="form-label">Select Answer</label>
                                <select class="form-select" name="answer" required>
                                    <option value="">Select Answer</option>
                                    <option id="sel-optionA"  value="a">Option A</option>
                                    <option  id="sel-optionB" value="b">Option B</option>
                                    <option  id="sel-optionC" value="c">Option C</option>
                                    <option  id="sel-optionD" value="d">Option D</option>
                                </select>
                                </div>
                                <div class="mb-3">
                                <label for="quiz_id" class="form-label">Select Quiz</label>
                                <select name="quiz_id" class="form-select" required>
                                    <option value="">Select Quiz</option>
                                    <?php
                            
                            $sql = "SELECT * FROM `quizzes`";

                            $query_run = mysqli_query($conn, $sql);

                            if ($query_run):

                                if (mysqli_num_rows($query_run)):
                                    foreach ($query_run as $row):
?>


                                    <option value="<?= $row['id']; ?>">
                                        <?= $row['name']; ?>
                                    </option>

                                    <?php
                endforeach;
                            else:
?>
                                    <option value="no">No Quiz Available</option>


                                    <?php

                            endif;

                            else:
                                echo "Some Error Occured";

                            endif;
                            
                            ?>
                                </select>

                            </div>
                            <div class="mb-3">
                            <label for="difficulty" class="form-label">Select Difficulty</label>
                                <select class="form-select" name="difficulty" required>
                                    <option value="">Select Difficulty</option>
                                    <option value="EASY">Easy</option>
                                    <option value="MEDIUM">Medium</option>
                                    <option value="HARD">Hard</option>
                                </select>
                                </div>
                            <button type="submit" name="add_ind_question" class="simple-btn btn btn-primary add-ind-question">Add</button>
                        </form>
                        </div>
                    <div class="modal-footer d-flex justify-content-start">

                        
                    </div>
               
            </div>
        </div>
    </div>


</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if (isset($_SESSION['status'])) {
    ?>
            swal("<?= $_SESSION['message']; ?>", {
                icon: "<?= $_SESSION['icon'] ?>",

            }
            );
    <?php
  unset($_SESSION['status']);
        unset($_SESSION['message']);
        unset($_SESSION['icon']);
    }

?>


</script>


<script>
        $(document).ready(function () {
            var table = $('#example').DataTable({
                language: {
                    searchPlaceholder: "Search Questions"
                },
                columnDefs: [
                    {
                        targets: 0,
                        checkboxes: {
                            selectRow: true
                        }
                    }
                ],
                select: {
                    style: 'multi'
                },
                order: [[1, 'asc']]

            });

        });



</script>
<script>





    function select_all() {
        if (jQuery('#delete').prop("checked")) {
            jQuery('input[class=input]').each(function (param) {
                jQuery('#' + this.id).prop('checked', true);
                // console.log(this.id);
            });
        } else {
            jQuery('input[class=input]').each(function (param) {
                jQuery('#' + this.id).prop('checked', false);
                // console.log(this.id);
            });
        }

    }




    function delete_all() {

        swal({
            title: "Are you sure?",
            text: "Are You Sure To Delete Questions !",
            icon: "warning",
            buttons: ["Cancel", "Yes ! Delete"],
            dangerMode: true,
        })
            .then((willDelete) => {
                if (willDelete) {
                    jQuery.ajax({
                        type: "post",
                        url: "code.php",
                        data: jQuery("#frm").serialize(),
                        success: function (response) {

                            jQuery('input[type=checkbox]').each(function () {
                                if (jQuery('#' + this.id).prop("checked")) {
                                    jQuery('#box' + this.id).remove();
                                }
                                swal({
                                    title: "Questions Deleted Successfully",
                                    text: "Questions Deleted",
                                    icon: "success",
                                });
                            });
                        }
                    });
                } else {

                }
            });



    }
</script>

<script>
    $('.edit-btn').click(function (e) {
        e.preventDefault();

        var ques_id = $(this).closest('tr').find('.ques_id').text();
        // console.log(quiz_id);
        $.ajax({
            type: "POST",
            url: "code.php",
            data: {
                'checking_edit_ques_btn': true,
                'ques_id': ques_id,
            },
            success: function (response) {
                // console.log(response);
                $.each(response, function (key, value) {
                    // console.log(value['name']);
                    $("#question").val(value['question']);
                    $("#id").val(value['id']);
                    $("#optionA").val(value['optionA']);
                    $("#optionB").val(value['optionB']);
                    $('#image').attr('src', value['image']);
                    $('.oldImage').val(value['image']);
                    $("#optionC").val(value['optionC']);
                    $("#optionD").val(value['optionD']);
                    switch (value['answer']) {
                        case value['optionA']:
                            $("#ans").val(value['answer']);
                            $("#ans").html('Option A');
                            $("#ansA").hide();
                            
                            break;
                            case value['optionB']:
                            $("#ans").val(value['answer']);
                            $("#ans").html('Option B');
                            $("#ansB").hide();
                            break;
                            case value['optionC']:
                            $("#ans").val(value['answer']);
                            $("#ans").html('Option C');
                            $("#ansC").hide();
                            break;
                            case value['optionD']:
                            $("#ans").val(value['answer']);
                            $("#ans").html('Option D');
                            $("#ansD").hide();
                            break;
                        default:
                            $("#ans").val('');
                            $("#ans").html('Select Answer');
                            break;
                    }
                    switch (value['difficulty']) {
                        case 'EASY':
                            $("#diff").val(value['difficulty']);
                            $("#diff").html('Easy');
                            // $("#easy").hide();
                            
                            break;
                            case 'MEDIUM':
                            $("#diff").val(value['difficulty']);
                            $("#diff").html('Medium');
                            // $("#medium").hide();
                            break;
                            case 'HARD':
                            $("#diff").val(value['difficulty']);
                            $("#diff").html('Hard');
                            // $("#hard").hide();
                            break;
                        default:
                            $("#diff").val('');
                            $("#diff").html('Select Difficulty');
                            break;
                    }
                    $.ajax({
                        type: "POST",
                        url: "code.php",
                        data: {
                            'get_quiz': true,
                            'quiz_id': value['quizId']
                        },
                        success: function (response) {
                            $.each(response, function (key, value) {
                                $("#ques_quiz").html(value['name']);
                                $("#ques_quiz").val(value['id']);
                                // console.log(value['name']);
                            });
                        }
                    });



                  
                });



                $('#editQuestion').modal('show');
            }
        });

    });
</script>

<script>
    $(document).ready(function () {
        $('.delete-question').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.delete-ques-id').val(id);
            $('#deleteModal').modal('show')
        });
    });

</script>


<script>
    $('.add-ind-question').on('click', function () {
        let optionA = $('#optionA').val();
        let optionB = $('#optionB').val();
        let optionC = $('#optionC').val();
        let optionD = $('#optionD').val();

        $('#sel-optionA').val(optionA);
        $('#sel-optionB').val(optionB);
        $('#sel-optionC').val(optionC);
        $('#sel-optionD').val(optionD);

    });
</script>


<?php

include("includes/footer.php");


?>